import ctypes
from ctypes import *


def initialization(id_usb):
    lib = ctypes.CDLL('MCSControl.dll')
    a=b"usb:id: "
    b=str.encode(id_usb)
    serial_number = a+b    #substitute this with the serial number on the smaract controller
    system_locator = ctypes.c_char_p(serial_number)

    inizializing_option = b"sync"
    options = ctypes.c_char_p(inizializing_option)

    system_index = ctypes.c_uint()

    #result = ctypes.c_uint()

    channel_index = ctypes.c_uint(0)

    direction = ctypes.c_uint(0)
    hold_time = ctypes.c_uint(0)
    auto_zero = ctypes.c_uint(0)

    lib.SA_OpenSystem.argtypes = [POINTER(ctypes.c_uint), c_char_p, c_char_p]
    result = lib.SA_OpenSystem(system_index, system_locator, options)
    #print(result)


    lib.SA_FindReferenceMark_S.argtypes = [ctypes.c_uint, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint, ctypes.c_uint]
    result = lib.SA_FindReferenceMark_S(system_index, channel_index, direction, hold_time, auto_zero)
    #print(result)

    while True:
        status = ctypes.c_int()
        lib.SA_GetStatus_S.argtypes = [ctypes.c_uint, ctypes.c_uint, POINTER(ctypes.c_int)]
        result = lib.SA_GetStatus_S(system_index, channel_index, status)
        #print(status.value)
        if status.value == 0:
            break


    lib.SA_GotoPositionAbsolute_S.argtypes = [ctypes.c_uint, ctypes.c_uint, ctypes.c_int, ctypes.c_uint]
    result = lib.SA_GotoPositionAbsolute_S(system_index, channel_index, 0, 0)
    #print(result)

    return system_index, channel_index;